/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.access.api.AcaClient;
import com.ibm.hsc.access.api.AcaRole;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.AccUtils;
import com.ibm.websm.diagnostics.IDebug;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class AccModify {
    private String[] m_AllProps = new String[]{"name", "parent", "resource"};
    private String m_target = null;
    private String m_file = null;
    private String m_rsrcs = null;
    private Hashtable m_rsrcTbl;
    public AcaClient m_acaCl = null;
    private HashMap m_validParams = new HashMap();
    private Vector m_input;
    private String m_partName = null;

    public AccModify() {
        this.m_validParams.put("-f", null);
        this.m_validParams.put("-t", null);
        this.m_validParams.put("-i", null);
    }

    protected void getMissingParamMsg(String string) throws PIHscClientException, RequiredParameterException {
        String[] stringArray = new String[]{string};
        AccUtils.throwRequiredParam(stringArray);
    }

    private void doChangeRole() throws PIHscClientException, RequiredParameterException {
        AcaRole acaRole;
        String[] stringArray;
        AccUtils.DBG("doChangeRole=" + (String)this.m_input.get(0));
        String string = "=";
        String string2 = AccUtils.parseStrData(AccUtils.NAME_TAG, (String)this.m_input.get(0));
        if (string2.length() <= 0) {
            AccUtils.DBG(AccUtils.NAME_TAG + " Tag does not exist in the input.");
            stringArray = new String[]{AccUtils.NAME_TAG};
            AccUtils.throwRequiredParam(stringArray);
        }
        if (((String)this.m_input.get(0)).indexOf(AccUtils.RESOURCE_TAG) < 0) {
            AccUtils.DBG("Tag: " + AccUtils.RESOURCE_TAG + " does NOT exist in the input data");
            stringArray = new String[]{AccUtils.RESOURCE_TAG};
            AccUtils.throwRequiredParam(stringArray);
        }
        if ((stringArray = this.m_acaCl.GetRoleProperty(string2)) == null) {
            AccUtils.DBG("Unknown role " + string2);
            AccUtils.throwInvalidParm(string2);
        }
        if ((acaRole = AccUtils.parseRoleData((AcaRole)(stringArray = this.m_acaCl.GetRoleProperty(stringArray.getParent())), (String)this.m_input.get(0), AccUtils.RESOURCE_TAG)) == null) {
            AccUtils.DBG("Unknown role " + string2);
            String string3 = AccUtils.getInvalidData();
            AccUtils.throwInvalidParm(string3);
        }
        if (this.m_acaCl.RedefineRole(acaRole) != 0) {
            AccUtils.throwCommandError(this.m_acaCl.GetMessage());
        }
        acaRole.dump();
    }

    private void doChangeGroup() throws PIHscClientException, RequiredParameterException {
        String[] stringArray;
        AccUtils.DBG("doChangeGroup=" + (String)this.m_input.get(0));
        int n = 0;
        String string = (String)this.m_input.get(0);
        String string2 = AccUtils.parseStrData(AccUtils.NAME_TAG, string);
        if (string2.length() <= 0) {
            AccUtils.DBG(AccUtils.NAME_TAG + " Tag does not exist in the input.");
            stringArray = new String[]{AccUtils.NAME_TAG};
            AccUtils.throwRequiredParam(stringArray);
        }
        if (string.indexOf(AccUtils.RESOURCE_TAG) < 0 && string.indexOf(AccUtils.RESOURCE_ADD_TAG) < 0 && string.indexOf(AccUtils.RESOURCE_REM_TAG) < 0) {
            AccUtils.DBG("None of the Tags: " + AccUtils.RESOURCE_TAG + ", " + AccUtils.RESOURCE_ADD_TAG + ", " + AccUtils.RESOURCE_REM_TAG + " exists in the input. Atleast one of them should be there.");
            stringArray = new String[]{AccUtils.RESOURCE_TAG + "," + AccUtils.RESOURCE_ADD_TAG + ", " + AccUtils.RESOURCE_REM_TAG};
            AccUtils.throwRequiredParam(stringArray);
        }
        if ((stringArray = this.m_acaCl.GetGroupProperty(string2)) == null) {
            AccUtils.DBG("Unknown group: " + string2);
            AccUtils.throwInvalidParm(string2);
        }
        String string3 = "hmcsuperadmin";
        AccUtils.DBG("name=" + string2 + " role=" + string3);
        AcaRole acaRole = this.m_acaCl.GetRoleProperty(string3);
        Vector vector = AccUtils.parseGroupDataForCreate(AccUtils.RESOURCE_ADD_TAG, string, acaRole);
        Vector vector2 = AccUtils.parseGroupDataForCreate(AccUtils.RESOURCE_REM_TAG, string, acaRole);
        Vector vector3 = AccUtils.parseGroupDataForCreate(AccUtils.RESOURCE_TAG, string, acaRole);
        vector.trimToSize();
        vector2.trimToSize();
        vector3.trimToSize();
        if (vector3.size() > 0) {
            AccUtils.DBG("RedefineGroup");
            n = this.m_acaCl.RedefineGroup(string2, vector3.toArray(new String[0]));
        } else {
            String[] stringArray2 = vector.size() <= 0 ? null : vector.toArray(new String[0]);
            String[] stringArray3 = vector2.size() <= 0 ? null : vector2.toArray(new String[0]);
            n = this.m_acaCl.ModifyGroup(string2, stringArray2, stringArray3);
        }
        if (n != 0) {
            AccUtils.DBG("Return code=" + n);
            AccUtils.SHOW(AcaClient.GetMessage((int)n));
            System.exit(AccUtils.FAILURE);
        }
    }

    public void performCommand() throws PIHscClientException, RequiredParameterException {
        String string = "";
        String string2 = "";
        String string3 = "";
        Hashtable hashtable = new Hashtable();
        Object var5_5 = null;
        AccUtils.DBG("m_target=" + this.m_target);
        if (this.m_target.equals("taskrole")) {
            AccUtils.DBG("processRole ...");
            this.doChangeRole();
        } else if (this.m_target.equals("resourcerole")) {
            AccUtils.DBG("processGroup ...");
            this.doChangeGroup();
        }
    }

    public void mapParameters(HashMap hashMap) throws PIHscClientException, RequiredParameterException {
        Object object;
        String string = "";
        AccUtils.DBG("In mapParameters, cmdParams = " + hashMap);
        this.m_target = (String)hashMap.get("-t");
        if (this.m_target == null || !this.m_target.equals("taskrole") && !this.m_target.equals("resourcerole")) {
            object = new String[]{"-t"};
            AccUtils.throwRequiredParam(object);
        }
        this.m_target = this.m_target.trim();
        this.m_input = new Vector();
        this.m_file = (String)hashMap.get("-f");
        if (this.m_file != null) {
            this.m_file = (String)hashMap.get(HMCCommandUtils.FILE_PARAM);
            if (this.m_file == null) {
                object = this.m_file;
                AccUtils.throwCmdLineSyntaxError((String)object, "FILE_NOT_FOUND");
            }
            try {
                this.m_input = PIHMCCommandUtils.readInputFile(this.m_file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string2 = this.m_file;
                AccUtils.throwCmdLineSyntaxError(string2, "FILE_NOT_FOUND");
            }
            catch (IOException iOException) {
                String string3 = this.m_file;
                AccUtils.throwCmdLineSyntaxError(string3, "FILE_NOT_FOUND");
            }
            AccUtils.DBG(this.m_input.toString());
        } else {
            this.m_rsrcs = (String)hashMap.get("-i");
            if (this.m_rsrcs == null || this.m_rsrcs.length() <= 0) {
                this.getMissingParamMsg("-i | -f");
            }
            this.m_input.add(this.m_rsrcs);
        }
        AccUtils.DBG("cmdParameter=" + hashMap);
    }

    public void printHelp() {
        String string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "ACCMOD_HELP");
        AccUtils.SHOW(string);
    }

    public static void main(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        try {
            String string2 = null;
            AccModify accModify = new AccModify();
            if (stringArray.length == 0) {
                accModify.printHelp();
            } else {
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = stringArray[i];
                    arrayList.add(string2);
                    if (!string2.equals("--help")) continue;
                    accModify.printHelp();
                    bl = true;
                    break;
                }
                if (!bl) {
                    HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, accModify.m_validParams);
                    accModify.mapParameters(hashMap);
                    accModify.m_acaCl = new AcaClient(1);
                    accModify.performCommand();
                }
            }
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                pIHscClientException.printStackTrace();
            }
            if ((string = pIHscClientException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
            }
            AccUtils.SHOW(string);
            System.exit(AccUtils.FAILURE);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            if ((string = throwable.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
            }
            AccUtils.SHOW(string);
            System.exit(AccUtils.FAILURE);
        }
        System.exit(AccUtils.SUCCESS);
    }
}

